/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.extendedexchange.block.entity;

import dev.ftb.extendedexchange.block.RelayBlock;
import dev.ftb.extendedexchange.block.entity.AbstractEMCBlockEntity;
import dev.ftb.extendedexchange.block.entity.ModBlockEntityTypes;
import dev.ftb.extendedexchange.util.EXUtils;
import java.util.ArrayList;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.block_entity.IEmcStorage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class RelayBlockEntity
extends AbstractEMCBlockEntity {
    public RelayBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.RELAY.get(), blockPos, blockState);
    }

    @Override
    public void tickServer() {
        BlockState state;
        Block block;
        if (this.storedEMC <= 0L) {
            return;
        }
        Level level = this.nonNullLevel();
        if (level.m_46467_() % 20L == 0L && (block = (state = this.m_58900_()).m_60734_()) instanceof RelayBlock) {
            RelayBlock relay = (RelayBlock)block;
            long relayTransfer = relay.matter.relayTransfer;
            ArrayList validTargets = new ArrayList(1);
            for (Direction direction : EXUtils.DIRECTIONS) {
                BlockEntity tileEntity = level.m_7702_(this.f_58858_.m_142300_(direction));
                if (tileEntity == null) continue;
                tileEntity.getCapability(PECapabilities.EMC_STORAGE_CAPABILITY).ifPresent(storage -> {
                    if (!storage.isRelay() && storage.insertEmc(1L, IEmcStorage.EmcAction.SIMULATE) > 0L) {
                        validTargets.add(storage);
                    }
                });
            }
            if (!validTargets.isEmpty() && this.storedEMC >= (long)validTargets.size()) {
                long perTarget = Math.min(this.storedEMC / (long)validTargets.size(), relayTransfer);
                for (IEmcStorage storage2 : validTargets) {
                    long inserted = storage2.insertEmc(perTarget, IEmcStorage.EmcAction.EXECUTE);
                    if (inserted <= 0L) continue;
                    this.storedEMC -= inserted;
                    this.m_6596_();
                    if (this.storedEMC >= perTarget) continue;
                    break;
                }
            }
        }
    }

    public boolean isRelay() {
        return true;
    }

    public void addBonus() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof RelayBlock) {
            RelayBlock relayBlock = (RelayBlock)block;
            this.insertEmc(relayBlock.matter.relayBonus, IEmcStorage.EmcAction.EXECUTE);
        }
    }
}

